#!/bin/sh

# backup_rootfs error code define
# these error code will be return
# to recovery main process
SCRIPT_ARGUMENT_ERROR='1'
LINUX_ROOTFS_UBIFS_CREATE_FAIL='2'
LINUX_DATA_UBIFS_CREATE_FAIL='3'
LINUX_ROOTFS_UBIIMG_CREATE_FAIL='4'
MODEM_UBIFS_CREATE_FAIL='5'
MODEM_UBIIMG_CREATE_FAIL='6'
# backup_rootfs errror code define end

mtd_file='/proc/mtd'
fifo_file='/dev/null'
backup_mode=''
ubi_attach_result=''
lebsize=''
pebsize=''
pagesize=''
subpagesize=''
CheckUBIAttach()
{
	volume=$1
	for ubidev in /dev/ubi[1-9]*_*; do # we must be start to check ubi from /dev/ubi1,because /dev/ubi0 is recoverfs(the rootfs of recover mode) 
		volname=`ubinfo $ubidev | grep "Name\:" | awk '{print $2}'`
		[ "$volname" = "$volume" ] && echo "$ubidev" && return 0
	done
	return 1
}

CheckAndAttachUBI()
{
	volume=$1
	ubi_attach_result=`CheckUBIAttach $volume`
	[ $? -eq 0 ] && return 0
    mtd_block_number=`cat $mtd_file | grep -i $partition | sed 's/^mtd//' | awk -F ':' '{print $1}'`
    if [ -z "$mtd_block_number" ]; then
       echo "MTD : Partition $partition not found"
    else
       echo "MTD : Attaching /dev/mtd${mtd_block_number}"
       ubiattach -m $mtd_block_number
       for loop in 1 2 3
       do
           ubi_attach_result=`CheckUBIAttach $partition`d
           [ $? -eq 0 ] && return 0
           sleep 0.01
       done
    fi
    return 1
}

CheckAndMountMTD()
{
	partition=$1
	volume=$2
	mount_point=$3
	CheckAndAttachUBI $volume
	mount | grep "${ubi_attach_result}"
	[ $? -ne 0 ] && mount -t ubifs ${ubi_attach_result} $mount_point
	sleep 1
}

BackupRootfs()
{
	echo "Rootfs backup start ..."
	CheckAndMountMTD "system" "rootfs" "/system"
	mkdir -p /dev/shm/cache

	mkfs.ubifs -m ${pagesize} -e ${lebsize}  -c 2146 -r /system -F -o /usrdata/cache/linux-rootfs.ubifs
	[ $? -ne 0 ] && exit ${LINUX_DATA_UBIFS_CREATE_FAIL} || echo "/usrdata/cache/linux-rootfs.ubifs create sucessfully"

	ubinize -o /dev/shm/cache/linux-sysfs.ubi -p ${pebsize} -m ${pagesize} -s ${pagesize} /etc/ubinize_system_rootfs.cfg
	[ $? -ne 0 ] && exit ${LINUX_ROOTFS_UBIIMG_CREATE_FAIL} || echo "/dev/shm/cache/linux-sysfs.ubi create sucessfully"
	ls -al /usrdata/cache
	rm -fr /usrdata/cache/linux-rootfs.ubifs
	rm -fr /usrdata/cache/linux-usrfs.ubifs
}

BackupModem()
{
	echo "Modem backup start ..."
	echo "progress:5%" > ${1}
	umount /firmware
	mkdir -p /system/firmware
	mkdir -p /dev/shm/cache
	CheckAndMountMTD "modem" "modem" "/system/firmware"
	mkfs.ubifs -m ${pagesize} -e ${lebsize}  -c 2146 -r /system/firmware -F -o /usrdata/cache/modem.ubifs
	[ $? -ne 0 ] && exit ${MODEM_UBIFS_CREATE_FAIL} || echo "/usrdata/cache/modem.ubifs create sucessfully"
	echo "progress:55%" > ${1}
	ubinize -o /dev/shm/cache/modem.ubi -p ${pebsize} -m ${pagesize} -s ${pagesize} /etc/ubinize_modem.cfg
	[ $? -ne 0 ] && exit ${MODEM_UBIIMG_CREATE_FAIL} || echo "/dev/shm/cache/modem.ubi create sucessfully"
	echo "progress:100%" > ${1}
	rm -fr /usrdata/cache/modem.ubifs
}

echo "backup uibfs start ..."
rm -fr /dev/shm/cache/* #delete file that recovery unzip update.zip to /dev/shm
rm -rf /usrdata/cache/modem.ubifs
rm -fr /usrdata/cache/linux-rootfs.ubifs
rm -fr /usrdata/cache/linux-usrfs.ubifs
[ $# -ne 2 ] && echo "backup rootfs or modem argument error!" && exit ${SCRIPT_ARGUMENT_ERROR}
fifo_file=${1}
backup_mode=${2}
echo "fifo_file:${1}"
lebsize=`ubinfo /dev/ubi0 | grep "Logical eraseblock size" | awk '{print $4}'`
pagesize=`ubinfo /dev/ubi0 | grep "Minimum input/output unit" | awk '{print $5}'`
pebsize=$((lebsize + pagesize*2))
[ "$backup_mode" = "rootfs" ] && BackupRootfs ${fifo_file}
[ "$backup_mode" = "modem" ] && BackupModem ${fifo_file}
echo "backup ${2} ok"

